//
// AVR IO pin simple operation macros
//
// Mikk Leini
// Department of Mechatronics
// Tallinn University of Technology
// 2009
//

//
// Common bit manipulation functions
//
#define BIT(x)                         (1 << (x))
#define SET_BIT(value, bit)            value |= BIT(bit)
#define CLEAR_BIT(value, bit)          value &= ~BIT(bit)
#define INVERT_BIT(value, bit)         value ^= BIT(bit)
#define SET_BIT_TO(value, bit, state)  value = ((state) ? (value | BIT(bit)) : (value & ~BIT(bit))) 
#define IS_BIT_SET(value, bit)         ((value) & (BIT(bit)))

//
// Bit manipulation with bitmask
//
#define SET_BITMASK(value, bitMask)            value |= (bitMask)
#define CLEAR_BITMASK(value, bitMask)          value &= ~(bitMask)
#define INVERT_BITMASK(value, bitMask)         value ^= (bitMask)
#define SET_BITMASK_TO(value, bitMask, state)  value = ((state) ? (value | (bitMask)) : (value & ~(bitMask))) 
#define IS_BITMASK_SET(value, bitMask)         ((value) & (bitMask))

//
// Simple port operations
//
// Method 1
//
// Short code, but doesn't support getting pin value as expression
//

#define PORTPIN(portChar, bitIndex) \
	DDR ## portChar = simple_dir_op(DDR ## portChar, bitIndex); \
	PORT ## portChar = simple_port_op(PORT ## portChar, bitIndex); \
	simple_pin_op(PIN ## portChar, bitIndex);

#define pin_setup_output(simplePin) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value | BIT(bit); } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value; } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_setup_input(simplePin) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value & ~BIT(bit); } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value | BIT(bit); } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_setup_tristate_input(simplePin) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value & ~BIT(bit); } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value; } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_set(simplePin) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value; } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value | BIT(bit); } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_clear(simplePin) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value; } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value & ~BIT(bit); } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_set_to(simplePin, newState) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value; } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) \
	{ \
		return ((newState) ? (value | BIT(bit)) : (value & ~BIT(bit))); \
	} \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_toggle(simplePin) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value; } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value ^ BIT(bit); } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { } \
	simplePin \
}

#define pin_get_value(simplePin, variable) \
{ \
	inline unsigned char simple_dir_op(unsigned char value, unsigned char bit) { return value; } \
	inline unsigned char simple_port_op(unsigned char value, unsigned char bit) { return value | BIT(bit); } \
	inline void simple_pin_op(unsigned char value, unsigned char bit) { variable = IS_BIT_SET(value, bit); } \
	simplePin \
}
